function getCalendar()
{
	var xmlHttp;
	try {
		/* Firefox, Opera 8.0+, Safari */
		xmlHttp=new XMLHttpRequest();
	} catch (e)	{
		/* newer IE */
		try	{
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e)	{
			/* older IE */
			try	{
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");
			}catch (e) {
				alert("Your browser is old and does not have AJAX support!");
				return false;
			}
		}
	}
	xmlHttp.onreadystatechange  = function(){ 
		if(xmlHttp.readyState  == 4){
			if(xmlHttp.status  == 200){
				prepareIcalData(xmlHttp.responseText);
			} else { 
				 alert("Error code " + xmlHttp.status);
			}
		}
	}
	xmlHttp.open("GET","ausland.ical",true);
	xmlHttp.send(null);
}

function prepareIcalData(data){
	try{
		var reader = new iCalReader();
		reader.prepareData(data);
		reader.parse();
		reader.sort();
	} catch(e){
		alert('error parsing data');
		return false;
	}
	var calendar = reader.getCalendar();
	var events = calendar.getEvents(); // Get all events.
	var eventList = document.createElement("ul");
	eventList.className = 'eventlist';
	eventList.id = 'eventlist';

	for(var i=0; i<calendar.getNrOfEvents(); i++) { // Loop through all events.
	
		var event = calendar.getEventAtIndex(i); // A single event.        
		
		// Get Javascript date for start and end time.
		var startDate = event.getStartDate();
		var title = event.getProperty('SUMMARY');
		var desc =  event.getProperty('DESCRIPTION');
		var url = event.getProperty('URL');
		
		var startDateString = startDate.format("ddd, dd.mm.yy 'um' HH:MM ");
		
		var eventListItem = document.createElement("li");
		var eventTime = document.createTextNode(startDateString);
		eventListItem.appendChild(eventTime);
		
		var eventLink = document.createElement("a");
		var eventText = document.createTextNode(title);
		eventLink.appendChild(eventText);
		eventLink.href = url;
		eventLink.title = desc;
		
		eventListItem.appendChild(eventLink);
		eventList.appendChild(eventListItem);
	
	}
	document.getElementsByTagName("body")[0].appendChild(eventList);
}


getCalendar();
