import jack
import subprocess
import pexpect
import sys
import time
import os

class Streaming:

    def is_darkice_running(self):
        ps = subprocess.Popen(['ps', '-A'], stdout=subprocess.PIPE)
        grep = subprocess.Popen(['grep', 'darkice'], stdin=ps.stdout, stdout=subprocess.PIPE)

        if grep.communicate()[0] != '':
            return True
        else:
            return False

    def killall_darkice(self):
        if not self.darkice and self.is_darkice_running():
            subprocess.call(['killall', 'darkice']) 

    def start_darkice(self):
        try:
            darkice = pexpect.spawn('darkice -c /home/ausland/.darksnow/darkice.cfg')
        except Exception:
            self.error("darkice: Error starting darkice")
            return False

        return darkice



    def connect_darkice(self):
        self.darkice.expect('Registering as JACK client')
        jack.attach('streaming')
        jack.activate()
        
        connections = []
        ports = jack.get_ports()
        for destination in ports:
            #print destination
            if destination.startswith('darkice'):
                old_source = jack.get_connections(destination)
                jack.disconnect(old_source[0], destination)
                if destination.endswith('left'):
                    source = 'system:capture_11'
                else:
                    source = 'system:capture_12'
                connections.append((source, destination))

        
        if len(connections) == 0:
            self.error('darkice: Error couldn\'t create jack connections')

        for source, destination in connections:
            jack.connect(source, destination)
        #print connections
        time.sleep(1)
        jack.deactivate()
        jack.detach()

    def error(self, error_msg):
        self.errors.append(error_msg)
        print error_msg

    def __init__(self):
        self.darkice = None
        self.errors = []
        self.jack = None

    def start(self):
        if self.is_darkice_running():
            self.error('darkice: darkice is already running')
            return False

        self.darkice = self.start_darkice()
        if not self.darkice: return False

        #time.sleep(10)
        
        self.connect_darkice()
        if not len(self.errors) == 0:
            return False

        return True



