import sys
import time
import os
import shutil
import subprocess
import pexpect


class Ardour:

    def is_ardour_running(self):
        ps = subprocess.Popen(['ps', '-A'], stdout=subprocess.PIPE)
        grep = subprocess.Popen(['grep', 'ardour'], stdin=ps.stdout, stdout=subprocess.PIPE)

        if grep.communicate()[0] != '':
            return True
        else:
            return False

    def get_unique_session_name(self, path, name):
        if not os.path.exists(path + name):
            return name
           
        counter = 1
        new_name = name + '_' + str(counter)
        while (os.path.exists(path + new_name)):
            new_name = name + '_' + str(counter)
            counter += 1

        return new_name
        

    def create_ardour_session_dir(self):
        curr_date_str = time.strftime('%d_%m_%y')
        curr_path = os.path.dirname(__file__)
        counter = 0

        new_name = self.get_unique_session_name(self.path, curr_date_str)

        try:
            shutil.copytree(curr_path+'/'+self.template_name, self.path + new_name)
        except OSError:
            self.error('ardour: Error creating ardour session')
            return False
        
        return new_name
        

    def prep_ardour_session(self, name):
        try:
            os.rename(self.path+name+'/interchange/'+self.template_interchange_name, self.path+name+'/interchange/'+name)
            os.rename(self.path+name+'/'+self.template_name+'.ardour', self.path+name+'/'+name+'.ardour')
        except OSError:
            self.error('ardour: Error preparing ardour session')
            return False

        return True
        
    def start_ardour(self):
        try:
            ardour = pexpect.spawn('ardour2 '+ self.path+self.name)
        except Exception:
            self.error("Ardour: Error starting ardour at "+ self.path+self.name)
            return False
        
        return ardour  

    def error(self, error_msg):
        self.errors.append(error_msg)
        print error_msg

    def __init__(self):
        self.template_name = '######'
        self.template_interchange_name = '______'
        self.path = '/home/ausland/Aufnahmen/'
        self.name = None
        self.errors = []
        self.ardour = None

    def start(self):
        running = self.is_ardour_running()

        if running:
            self.error("ardour: Another instance is already running")
            return False

        self.name = self.create_ardour_session_dir()
        if not self.name: return False

        session = self.prep_ardour_session(self.name)
        if not session: return False

        self.ardour = self.start_ardour()
        if not self.ardour: return False

        if not (len(self.errors) == 0):
            return False
        
        return True


